function cellDivision_GUI(model,reactions,nbCells,offset,rep_time,spread,sim_time,events)
%
% Copyright 2008 Nick Van Damme


clc

%starting point: initial population
init = nbCells;
for i = 2:init
    addCell(model,reactions,i)
end

global tt xx
tt = []; xx = []; NAMES=[];
cs = model.getconfigset('default');
if offset~= 0
    set(cs, 'StopTime', offset );
    [tt,xx] = sbiosimulate(model, cs);
    %adjust events to offset
    for i=1:size(events,1)
        events{i,1} = events{i,1} + offset;
    end
end

%division moments
global div
div = [ 1:init ; rep_time + spread * randn(1,init)];


global start_time end_time
start_time = offset;
end_time = start_time;
end_sim = offset + sim_time;
count = init;

while start_time < end_sim

    %sorting --> new sim-time at first place
    [div(2,:),IX] = sort(div(2,:));
    h = zeros(1,size(div,2));
    for i=1:size(div,2)
        h(1,i) = div(1,IX(i));
    end
    div(1,:) = h;

    % simulate
    end_time = start_time + div(2,1);
    events = event_function(model,events);
    set(cs, 'StopTime', div(2,1) );
    [t,x] = sbiosimulate(model, cs);
    tt = [tt ; t+repmat(start_time,length(t),1) ];
    xx = [xx zeros(size(xx,1),size(x,2)-size(xx,2)); x ];

    %adjust initial conditions (for next simulation)
    for j=1:size(x,2)
        model.species(j).InitialAmount = max(x(end,j),0);
    end

    %add new cell
    count = count + 1; %display............................................
    addCell(model,reactions,count);
    cellDiv(['cell' num2str(div(1,1))],['cell' num2str(count)]);
    %adjust div
    div(2,:) = div(2,:) - repmat(div(2,1),1,size(div,2)); %shift div
    div(2,1) = rep_time + spread * randn(1); %new time for first div.
    div(:,count) = [ count ; rep_time + spread * randn(1) ]; %new time for new cell

    start_time = end_time; %display........................................
end
% allow for levelling of latest situation
set(cs, 'StopTime', offset );
[t,x,NAMES] = sbiosimulate(model, cs);
tt = [tt ; t+repmat(start_time,length(t),1) ];
xx = [xx zeros(size(xx,1),size(x,2)-size(xx,2)); x ];


save 'output.mat' tt xx NAMES;